/**
* Script: yesnostate.js
* Written by: Radnen
* Updated: 12/19/2010
**/

function YesNoState(text, name) {
	if (!name) name = "YesNoState";
	this.inherit = State;
	this.inherit(name);
	
	this.x = SW/2-150;
	this.y = SH/2-50;
	this.text = text;
	
	this.onOkay = new Event(this);
	this.onCancel = new Event(this);
	
	this.okaybutton = new EasyButton("Okay", this.x+200, this.y+64);
	this.okaybutton.onClick.add(function(sender) {
		sender.hide();
		sender.onOkay.execute();
	}, this);
	
	this.cancelbutton = new EasyButton("Cancel", this.x+50, this.y+64);
	this.cancelbutton.onClick.add(function(sender) {
		sender.hide();
		sender.onCancel.execute();
	}, this);

	this.render.add(function() {
		Rectangle(this.x, this.y, 300, 100, Colors.black);
		OutlinedRectangle(this.x, this.y, 300, 100, Colors.gray);
		System.textFont.drawTextBox(this.x+4, this.y+4, 292, 64, 0, this.text);
		this.okaybutton.draw();
		this.cancelbutton.draw();
	});
	
	this.update.add(function() {
		this.okaybutton.update();
		this.cancelbutton.update();
	});
}